
# line 3 "langparser.y"

/*
langparser.y generates langparser.c.  

use MPW Shell and the MPW tool MacYACC to create a LSC-compatible parser 
in langparser.c.
*/

/*
these declarations make it possible to compile and run langparser.c 
with no modification to the source code as generated by MacYACC.

5/29/92 dmb: added try statement handling

5.1.2 dmb: added cleanandexit block to dispose everything on memory errors
*/

#ifdef MACVERSION
#include <standard.h>
#endif

#ifdef WIN95VERSION
#include "standard.h"
#endif

#include "memory.h"
#include "strings.h"
#include "lang.h"
#include "langinternal.h"
#include "langparser.h"
#include <stdio.h>
#include <string.h>


static FILE __file[1];

static int fprintf (FILE *f, const char *s, ...) {return (0);}

static FILE *fopen (const char *s1, const char *s2) {return (NULL);}

static int fclose (FILE *f) {return (0);}

static int strcmp (const char * str1, const char * str2) {return (0);}

/*
10/2/91 dmb: a disturbing discovery -- our error handling doesn't deallocate 
any of the code tree that's been built so for.  searching through langparser.c, 
it appears that there are three data structures will need to go through: yyval, 
yylval, and the value stack, yyv.  Unfortunately, the value stack pointer, yypv, 
is a local in yyparse, so we have to be tricky to get at it.  so I'm replacing 
the yyerror routine with a macro that calls the real error routine, but passes 
the stack pointer as an additional parameter.

there's probably a much cleaner way to do this, but I don't have the 
documentation, nor much time...

11/22/91 dmb: well, there's little time indeed, but we now have MacYACC 3.0, and 
a little documentation.  The right was to deal with data structure disposal on 
errors is to make sure that there are reduction rules for every error situation, 
so that after yyerror is called the parser can ruduce the stack all the way down 
to our start token (module), where the tree can be safely disposed.  I've added a 
number of such reductions that should cover many error situations, but a much more 
thorough job needs to be done eventually.  It's hard to trap errors at a very atomic 
level without introducing ambiguities to the grammer (i.e. reduction conflicts).  
So, given the time to work on it, I would go through the definition of "statement" 
and add rules for every permutation of errors within the more complex contructs.  The 
key thing to understand is that "expr" is written to handle any error, so anything 
that depends on expr is covered.  It's unique contructs associated with some compound 
statements that need extra work.
*/

#define EQtoken 400
#define NEtoken 401
#define GTtoken 402
#define LTtoken 403
#define GEtoken 404
#define LEtoken 405
#define nottoken 406
#define andandtoken 407
#define orortoken 408
#define beginswithtoken 409
#define endswithtoken 410
#define containstoken 411
#define bitandtoken 412
#define bitortoken 413
#define looptoken 500
#define filelooptoken 501
#define intoken 502
#define breaktoken 503
#define returntoken 504
#define iftoken 505
#define thentoken 506
#define elsetoken 507
#define bundletoken 508
#define localtoken 509
#define ontoken 510
#define whiletoken 511
#define casetoken 512
#define kerneltoken 513
#define fortoken 514
#define totoken 515
#define downtotoken 516
#define continuetoken 517
#define withtoken 518
#define trytoken 519
#define globaltoken 520
#define errortoken 292
#define eoltoken 293
#define constanttoken 294
#define identifiertoken 295
#define othertoken 296
#define assigntoken 297
#define addtoken 298
#define subtracttoken 299
#define multiplytoken 300
#define dividetoken 301
#define modtoken 302
#define plusplustoken 303
#define minusminustoken 304
#define unaryminus 305
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
#define YYERRCODE 256

# line 1450 "langparser.y"


#ifdef fldebug

	static void yytrace (char * s) {
		
		bigstring bs;
		
		copyctopstring (s, bs);
		
		langtrace (bs);
		} /*yytrace*/

#else

	#define yytrace(s)

#endif


static int yylex (void) {
	
	/*
	get the next token from the input stream.  return the token number, and
	set the global yylval to the value of the token, if it has one.
	*/
	
	return (parsegettoken (&yylval));
	} /*yylex*/


static void yyerror (char *s) {
	
	/*
	langdisposetree (yyval);
	
	langdisposetree (yylval);
	*/
	
	/*
	clearbytes (&parseresult, (long) sizeof (parseresult));
	*/
	
	parseerror ((ptrstring) s); 
	} /*yyerror*/




FILE *yytfilep;
char *yytfilen;
int yytflag = 0;
int svdprd[2];
char svdnams[2][2];

const int yyexca[] = {
  -1, 1,
  0, -1,
  -2, 0,
  0,
};

#define YYNPROD 131
#define YYLAST 1078

const int yyact[] = {
      27,     170,     234,      50,      51,      52,      53,      54,
     163,     159,     241,     216,      46,     214,      70,      50,
      51,      52,      53,      54,      67,      27,      48,     197,
      23,      52,      53,      54,      46,     250,      46,      49,
     204,      81,      70,      70,     182,      74,      31,      96,
      67,      67,      27,     144,     190,      23,     153,     249,
      81,     146,     167,      46,      50,      51,      52,      53,
      54,     247,     166,      78,     248,     152,       4,      46,
     196,      68,      23,     106,      66,     192,      76,      91,
      46,      50,      51,      52,      53,      54,     208,     203,
     218,      48,     184,      30,     193,      68,      68,     113,
      66,      66,      46,      97,     217,      46,      50,      51,
      52,      53,      54,      50,      51,      52,      53,      54,
      30,      55,      56,      59,      57,      60,      58,     119,
      65,      64,      61,      62,      63,      55,      56,      59,
      57,      60,      58,     188,      65,      30,      61,      62,
      63,     192,     183,     168,     186,     187,     179,     169,
     140,      70,      46,     156,     157,     158,      79,      67,
     193,     202,     103,     189,     261,     244,     200,     185,
     160,      77,      55,      56,      59,      57,      60,      58,
     191,      65,      64,      61,      62,      63,      75,     105,
      70,     171,      75,     263,     110,     173,      67,      55,
      56,      59,      57,      60,      58,      75,      65,      64,
      61,      62,      63,     109,      68,      87,     142,      66,
     104,     155,     262,     137,      55,      56,      59,      57,
      60,      58,     116,      65,      64,      61,      62,      63,
     149,       2,     198,     236,      21,      20,     192,     161,
      45,     143,      19,      68,     253,     254,      66,      50,
      51,      52,      53,      54,     155,     193,     229,     227,
      45,     213,      45,     209,     225,       3,     145,     231,
     232,      50,      51,      52,      53,      54,      88,      15,
      14,      13,     176,      12,      11,      10,      22,      45,
      47,     215,     150,      28,      32,     139,      34,      25,
      26,     195,     260,      45,     246,     239,     240,     221,
       7,       1,       0,      22,      45,      71,      72,       0,
      28,       0,       0,       0,      25,      26,      50,      51,
      52,      53,      54,     175,      69,       0,      45,      49,
      22,      45,      71,      72,       0,      28,     170,       0,
     199,      25,      26,     192,     255,       0,       0,       0,
     257,       0,      50,      51,      52,      53,      54,       0,
     207,       0,     193,       0,       0,      55,      56,      59,
      57,      60,      58,       0,      65,      64,      61,      62,
      63,      50,      51,      52,      53,      54,      45,      55,
      56,      59,      57,      60,      58,     165,      65,      64,
      61,      62,      63,     194,       0,       0,     192,       0,
       0,       0,       0,       0,       0,       0,      29,       0,
       0,       0,       0,       0,       0,     193,       0,       0,
       0,       0,       0,       0,       0,       0,       0,       0,
     180,       0,       0,      29,      55,      56,      59,      57,
      60,      58,       0,      65,      64,      61,      62,      63,
      71,      72,       0,       0,       0,       0,       0,       0,
      29,       0,       0,       0,       0,       0,       0,       0,
      55,      56,      59,      57,      60,      58,       0,      65,
      64,      61,      62,      63,      50,      51,      52,      53,
      54,       0,       0,       0,       0,       0,       0,      55,
      56,      59,      57,      60,      58,       0,      65,      64,
      61,      62,      63,      50,      51,      52,      53,      54,
       0,       0,     181,       0,      37,      36,       0,      16,
      18,      40,       0,       0,      41,       8,      35,      38,
      42,     151,      39,       0,     222,      17,      43,      44,
       9,      37,      36,       0,      16,      18,      40,       0,
       0,      41,       8,      35,      38,      42,       0,      39,
     177,       0,      17,      43,      44,       9,      37,      36,
       0,      16,      18,      40,       0,       0,      41,       8,
      35,      38,      42,       0,      39,       0,       0,      17,
      43,      44,       9,      50,      51,      52,      53,      54,
       0,       0,      55,      56,      59,      57,      60,      58,
       0,      65,      64,      61,      62,      63,      50,      51,
      52,      53,      54,       0,      27,       0,       0,       0,
       0,      55,      56,      59,      57,      60,      58,       0,
      65,      64,      61,      62,      63,      50,      51,      52,
      53,      54,       0,      24,      23,       0,       0,       0,
       0,      50,      51,      52,      53,      54,       0,       0,
       0,       0,       0,       0,       0,      50,      51,      52,
      53,      54,       0,      95,       0,      95,      95,      46,
       0,       0,       0,       0,       0,       0,      50,      51,
      52,      53,      54,      95,       0,       0,       0,      95,
       0,       0,      50,      51,      52,      53,      54,       0,
       0,      55,      56,      59,      57,      60,      58,      30,
      65,      64,      61,      62,      63,      50,      51,      52,
      53,      54,       0,       0,      55,      56,      59,      57,
      60,      58,       0,      65,      64,      61,      62,      63,
       0,       0,       0,       0,       0,       0,       0,       0,
       0,       0,       0,      55,      56,      59,      57,      60,
      58,       0,      65,      64,      61,      62,      63,      55,
      56,      59,      57,      60,      58,       0,      65,      64,
      61,      62,      63,      55,      56,      59,      57,      60,
      58,       0,      65,      64,      61,      62,      63,       0,
       0,       0,       0,       0,      55,      56,      59,      57,
      60,      58,       0,      65,      64,      61,      62,      63,
      55,      56,      59,      57,      60,      58,       0,       5,
       0,      61,      62,      63,       0,       0,       0,       0,
       0,       0,       0,       0,       0,      59,      57,      60,
      58,       0,      89,       0,      61,      62,      63,      95,
       0,       0,       0,     100,     101,     102,     107,       0,
       0,       0,       0,      95,       0,       0,     111,       0,
     114,       0,     115,       0,       0,       0,     118,       0,
       0,       0,     120,     121,     122,     123,     124,     125,
     126,     127,     128,     129,     130,     131,     132,     133,
     134,     135,       0,       0,     138,     141,     147,      90,
       6,       0,      22,      45,       0,       0,       0,      28,
       0,       0,       0,      25,      26,       0,       0,       0,
       0,       0,       0,     162,       0,       0,       0,      94,
     164,      98,      99,       0,       0,       0,       0,       0,
       0,       0,       0,       0,       0,       0,     174,     112,
       0,     164,     205,     117,       0,       0,       0,       0,
       6,      33,      73,       0,       0,      80,      82,      83,
      84,      85,      86,       0,       0,       0,       0,      92,
      93,       0,       0,       0,       0,       0,       0,       0,
       0,       0,       6,       0,       0,       0,       0,       0,
       0,       6,       0,       0,       0,     108,       0,       0,
       0,       0,       0,       0,       0,       0,       0,     210,
       0,     211,     212,       0,       0,       0,       0,     219,
       0,     220,       0,       0,       0,     224,       6,       0,
       0,     178,      29,     211,     228,     136,       0,       0,
     148,       0,       0,       0,     233,       0,     154,     154,
     154,     154,       0,     235,       0,       0,       0,       0,
       0,       0,       0,       0,       0,       0,       0,     237,
       0,     238,       0,       0,       0,     242,     243,       0,
       0,       0,       0,       0,       0,       0,       0,     172,
       0,       0,       0,       0,       0,       0,       0,     251,
     252,       0,       0,       0,       0,       0,       0,       0,
     256,       0,       0,     223,       0,     258,     259,       0,
       0,       0,       0,       0,       0,       0,       0,     230,
       0,       0,       0,       0,       0,       0,       0,       0,
       0,       0,     201,       0,       0,       0,     206,       0,
       0,       0,       0,       0,       0,       0,       0,       0,
       0,       0,       0,       0,       0,     154,       0,       0,
       0,       0,       0,       0,       0,       0,       0,       0,
       0,       0,       0,       0,     226,     148,       0,       0,
       0,       0,     154,     154,       0,       0,       0,       0,
       0,       6,       0,       0,       0,       0,       0,       0,
       0,       0,       0,       0,       0,       0,       0,       0,
       0,       0,       0,       0,       0,       0,       0,       0,
       0,       0,       0,       0,       0,     245,
};

const int yypact[] = {
     -19,   -1000,     -37,   -1000,   -1000,    -225,      -5,     -86,
      30,      19,     -90,     -90,     -90,     -90,     -90,     -90,
     149,   -1000,     508,     -52,     -90,     -90,   -1000,      -1,
      -3,      -1,      -1,     508,     508,     508,     508,   -1000,
   -1000,   -1000,   -1000,     -79,     147,     132,     508,      47,
     508,   -1000,     508,      -1,   -1000,   -1000,     508,   -1000,
       2,   -1000,     508,     508,     508,     508,     508,     508,
     508,     508,     508,     508,     508,     508,     508,     508,
     508,     508,   -1000,     -61,     508,     508,     508,   -1000,
   -1000,   -1000,     -40,   -1000,     -63,     -63,     -63,     -63,
   -1000,       2,   -1000,   -1000,   -1000,    -498,   -1000,     111,
   -1000,    -204,      97,     508,   -1000,    -499,     128,      -3,
     508,   -1000,     128,     128,     308,   -1000,   -1000,     -67,
       6,      91,   -1000,     244,     129,     -79,       2,    -204,
      -6,     508,    -204,    -204,      90,     128,     291,   -1000,
    -275,    -275,   -1000,   -1000,   -1000,     339,     339,    -199,
    -199,    -199,    -199,    -199,    -199,    -199,    -283,     320,
   -1000,   -1000,     -57,      37,     -11,    -204,     110,   -1000,
      88,      89,   -1000,    -204,      65,      22,     -81,     120,
     314,   -1000,    -233,   -1000,      85,     263,      25,     -90,
   -1000,      20,     -75,     -90,     279,     -16,   -1000,     508,
   -1000,     508,     508,     -28,    -245,      33,      39,     508,
   -1000,     508,     -26,      -1,   -1000,     508,   -1000,   -1000,
   -1000,   -1000,     -79,     508,     508,   -1000,   -1000,      -1,
     -63,     -63,   -1000,   -1000,     508,   -1000,   -1000,   -1000,
   -1000,   -1000,    -505,     508,   -1000,   -1000,   -1000,     -16,
   -1000,   -1000,     244,    -204,    -204,     170,   -1000,     508,
   -1000,     508,   -1000,    -246,    -204,     508,     508,     128,
    -204,   -1000,      65,      88,    -204,     108,     128,   -1000,
   -1000,    -204,     -90,     -75,   -1000,      16,     -12,     508,
     508,   -1000,    -295,     267,   -1000,   -1000,   -1000,   -1000,
     508,       2,   -1000,    -204,    -204,     508,     508,   -1000,
     225,     107,     153,     130,   -1000,   -1000,   -1000,   -1000,
};

const int yypgo[] = {
       0,     273,     208,     849,     727,     272,      61,     265,
      46,      62,     842,     262,     799,     571,      38,     261,
     260,      67,     258,     253,     252,     251,     249,     248,
     247,     246,     218,     215,     213,     212,      32,     202,
     167,     146,     192,      49,      43,     190,
};

const int yyr1[] = {
       0,       1,       1,       3,       3,       5,       5,       7,
       7,       7,       8,       8,       6,       6,       6,       2,
       2,      10,      10,      11,      11,      11,      14,      14,
      15,      16,      16,      16,      12,      12,      12,      12,
       9,       9,       9,       9,       9,       9,       9,       9,
       9,       9,       9,       9,       9,       9,       9,       9,
       9,       9,       9,       9,       9,       9,       9,       9,
       9,       9,      18,      19,      19,      19,      20,      20,
      20,      20,      20,      21,      21,      21,      21,      21,
      21,      22,      22,      23,      29,      24,      26,      30,
      30,      27,      27,      28,      31,      31,      32,      32,
      33,      33,      25,      25,      17,      34,      34,      35,
      36,      36,      37,      37,      37,      13,       4,       4,
       4,       4,       4,       4,       4,       4,       4,       4,
       4,       4,       4,       4,       4,       4,       4,       4,
       4,       4,       4,       4,       4,       4,       4,       4,
       4,       4,       4,
};

const int yyr2[] = {
       0,       2,       1,       1,       3,       5,       4,       0,
       2,       1,       2,       1,       1,       3,       3,       1,
       3,       3,       1,       2,       2,       4,       3,       3,
       3,       4,       4,       4,       1,       1,       1,       1,
       0,       1,       3,       2,       4,       4,       4,       4,
       4,       2,       2,       2,       2,       2,       4,       2,
       3,       1,       1,       2,       4,       6,       2,       2,
       4,       2,       4,       6,       8,       4,       8,       1,
       4,       2,       6,       6,       8,       6,       8,       5,
       3,       4,       6,       2,       1,       1,       2,       0,
       1,       2,       4,       2,       1,       3,       1,       3,
       0,       1,       0,       1,       3,       1,       3,       3,
       1,       3,       1,       1,       3,       4,       1,       1,
       2,       1,       2,       2,       2,       2,       3,       3,
       3,       3,       3,       3,       3,       3,       3,       3,
       3,       3,       3,       3,       3,       3,       3,       2,
       2,       3,       3,
};

const int yychk[] = {
   -1000,      -1,      -2,     256,      -9,      -4,     -12,      -5,
     509,     520,     -19,     -20,     -21,     -22,     -23,     -24,
     503,     517,     504,     -26,     -28,     -29,     294,      64,
     -13,     303,     304,      40,     299,     406,     123,     -14,
     -16,      -3,     -11,     510,     501,     500,     511,     514,
     505,     508,     512,     518,     519,     295,      91,     293,
      59,     256,     298,     299,     300,     301,     302,     400,
     401,     403,     405,     402,     404,     409,     410,     411,
     408,     407,      94,      46,      91,     297,      40,     303,
     304,     -10,     123,     256,      40,     123,      40,     123,
     -10,     123,     -10,     -10,     -10,     -10,     -10,      40,
     -25,      -4,     -12,     123,     -10,     -10,     -12,     -13,
      40,      94,     -12,     -12,      -4,      -4,      -4,     -33,
     -34,     -32,     -17,      -4,      -3,      40,      40,      -4,
     -12,      40,      -4,      -4,     -31,     -12,      -4,      -9,
      -4,      -4,      -4,      -4,      -4,      -4,      -4,      -4,
      -4,      -4,      -4,      -4,      -4,      -4,      -4,      -4,
      -3,     256,      -4,     -15,     -17,      -4,     -37,     -33,
     -36,     -32,     -35,      -4,      -3,      -2,     -18,     513,
      -6,      -8,      -3,     256,      -6,      -6,      -6,     507,
      41,     -27,      -4,     507,      -4,      41,     125,      44,
     125,      44,      58,      40,      -3,      -9,      -4,     297,
     256,     502,     -12,      44,      93,     515,      93,      93,
      93,      41,      44,      44,      58,     125,     125,      40,
      44,      59,      41,      -7,     297,     256,     125,      41,
     125,     -10,     125,      59,     -30,     -10,     -10,      41,
      94,     -17,      -4,      -4,      -4,      -6,      41,     502,
     256,      59,      41,      -4,      -4,     297,     502,     -12,
      -4,     -35,      -3,     -36,      -4,     -14,     -12,      -8,
      -8,      -4,     507,      -4,      41,      -4,      -4,     515,
     516,     256,      -4,      -4,      41,     -10,     -30,      41,
      44,      59,      41,      -4,      -4,     515,     516,      41,
      -4,      -9,      -4,      -4,      41,      41,      41,      41,
};

const int yydef[] = {
      32,      -2,       0,       2,      15,      33,     103,       0,
       0,       0,       0,       0,       0,       0,       0,       0,
      49,      50,      90,       0,       0,       0,     102,       0,
     105,       0,       0,       0,       0,       0,      88,      28,
      29,      30,      31,       0,       0,      63,       0,       0,
       0,      77,       0,       0,      76,       3,       0,       1,
      32,      57,       0,       0,       0,       0,       0,       0,
       0,       0,       0,       0,       0,       0,       0,       0,
       0,       0,      19,       0,       0,       0,      88,     107,
     109,      35,      32,      18,       0,       0,       0,       0,
      41,      32,      42,      43,      44,      45,      47,       0,
      51,      91,     103,       0,      54,      55,     104,       0,
       0,      20,     106,     108,       0,     127,     128,       0,
       0,      89,      93,      86,       0,       0,      32,      65,
       0,       0,      75,      78,      83,      84,       0,      16,
     111,     112,     113,     114,     115,     116,     117,     118,
     119,     120,     121,     122,     123,     124,     125,     126,
      22,      23,       0,       0,       0,      34,       0,      98,
      99,      89,      96,      86,      30,       0,       0,       0,
       0,      12,       7,      11,       0,       0,       0,       0,
      48,       0,      79,       0,       0,     110,     129,       0,
     130,       0,       0,       0,       0,       0,      33,       0,
      72,       0,     103,       0,       4,       0,      25,      26,
      27,     101,       0,       0,       0,      17,      36,       0,
       0,       0,      37,      10,       0,       9,      38,      39,
      40,      46,      52,       0,      81,      80,      56,       0,
      21,      94,       0,      87,      92,       0,       6,       0,
      61,       0,      64,       0,      73,       0,       0,      85,
      24,      97,       0,     100,      95,      28,       0,      13,
      14,       8,       0,      79,       5,       0,       0,       0,
       0,      71,       0,       0,      58,      53,      82,      59,
       0,      32,      66,      67,      69,       0,       0,      74,
       0,       0,       0,       0,      60,      62,      68,      70,
};

const int *yyxi;
/*****************************************************************/
/* PCYACC LALR parser driver routine -- a table driven procedure */
/* for recognizing sentences of a language defined by the        */
/* grammar that PCYACC analyzes. An LALR parsing table is then   */
/* constructed for the grammar and the skeletal parser uses the  */
/* table when performing syntactical analysis on input source    */
/* programs. The actions associated with grammar rules are       */
/* inserted into a switch statement for execution.               */
/*****************************************************************/


#ifndef YYMAXDEPTH
#define YYMAXDEPTH 200
#endif
#ifndef YYREDMAX
#define YYREDMAX 1000
#endif
#define PCYYFLAG -1000
#define WAS0ERR 0
#define WAS1ERR 1
#define WAS2ERR 2
#define WAS3ERR 3
#define yyclearin pcyytoken = -1
#define yyerrok   pcyyerrfl = 0
YYSTYPE yyv[YYMAXDEPTH];     /* value stack */
int pcyyerrct = 0;           /* error count */
int pcyyerrfl = 0;           /* error flag */
int redseq[YYREDMAX];
int redcnt = 0;
int pcyytoken = -1;          /* input token */


yyparse()
{
  int statestack[YYMAXDEPTH]; /* state stack */
  int      j, m;              /* working index */
  YYSTYPE *yypvt;
  int      tmpstate, *yyps, n;
  YYSTYPE *yypv;

#ifdef YYDEBUG
  int tmptoken = -1;
#endif


  tmpstate = 0;
  pcyytoken = -1;
  pcyyerrct = 0;
  pcyyerrfl = 0;
  yyps = &statestack[-1];
  yypv = &yyv[-1];


  enstack:    /* push stack */
#ifdef YYDEBUG
    printf("at state %d, next token %d\n", tmpstate, tmptoken);
#endif
    if (++yyps - &statestack[YYMAXDEPTH-1] > 0) {
      yyerror("pcyacc internal stack overflow");
      return(1);
    }
    *yyps = tmpstate;
    ++yypv;
    *yypv = yyval;


  newstate:
    n = yypact[tmpstate];
    if (n <= PCYYFLAG) goto defaultact; /*  a simple state */


    if (pcyytoken < 0) if ((pcyytoken=yylex()) < 0) pcyytoken = 0;
    if ((n += pcyytoken) < 0 || n >= YYLAST) goto defaultact;


    if (yychk[n=yyact[n]] == pcyytoken) { /* a shift */
#ifdef YYDEBUG
      tmptoken  = pcyytoken;
#endif
      pcyytoken = -1;
      yyval = yylval;
      tmpstate = n;
      if (pcyyerrfl > 0) --pcyyerrfl;
      goto enstack;
    }


  defaultact:


    if ((n=yydef[tmpstate]) == -2) {
      if (pcyytoken < 0) if ((pcyytoken=yylex())<0) pcyytoken = 0;
      for (yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=tmpstate); yyxi += 2)
      	;
      while (*(yyxi+=2) >= 0) if (*yyxi == pcyytoken) break;
      if ((n=yyxi[1]) < 0) { /* an accept action */
        if (yytflag) {
          int ti; int tj;
          yytfilep = fopen(yytfilen, "w");
          if (yytfilep == NULL) {
            fprintf(stderr, "Can't open t file: %s\n", yytfilen);
            return(0);          }
          for (ti=redcnt-1; ti>=0; ti--) {
            tj = svdprd[redseq[ti]];
            while (strcmp(svdnams[tj], "$EOP"))
              fprintf(yytfilep, "%s ", svdnams[tj++]);
            fprintf(yytfilep, "\n");
          }
          fclose(yytfilep);
        }
        return (0);
      }
    }


    if (n == 0) {        /* error situation */
      switch (pcyyerrfl) {
        case WAS0ERR:          /* an error just occurred */
          yyerror("syntax error");
          yyerrlab:
            ++pcyyerrct;
        case WAS1ERR:
        case WAS2ERR:           /* try again */
          pcyyerrfl = 3;
	   /* find a state for a legal shift action */
          while (yyps >= statestack) {
	     n = yypact[*yyps] + YYERRCODE;
	     if (n >= 0 && n < YYLAST && yychk[yyact[n]] == YYERRCODE) {
	       tmpstate = yyact[n];  /* simulate a shift of "error" */
	       goto enstack;
            }
	     n = yypact[*yyps];


	     /* the current yyps has no shift on "error", pop stack */
#ifdef YYDEBUG
            printf("error: pop state %d, recover state %d\n", *yyps, yyps[-1]);
#endif
	     --yyps;
	     --yypv;
	   }


	   yyabort:
            if (yytflag) {
              int ti; int tj;
              yytfilep = fopen(yytfilen, "w");
              if (yytfilep == NULL) {
                fprintf(stderr, "Can't open t file: %s\n", yytfilen);
                return(1);              }
              for (ti=1; ti<redcnt; ti++) {
                tj = svdprd[redseq[ti]];
                while (strcmp(svdnams[tj], "$EOP"))
                  fprintf(yytfilep, "%s ", svdnams[tj++]);
                fprintf(yytfilep, "\n");
              }
              fclose(yytfilep);
            }
	     return(1);


	 case WAS3ERR:  /* clobber input char */
#ifdef YYDEBUG
          printf("error: discard token %d\n", pcyytoken);
#endif
          if (pcyytoken == 0) goto yyabort; /* quit */
	   pcyytoken = -1;
	   goto newstate;      } /* switch */
    } /* if */


    /* reduction, given a production n */
#ifdef YYDEBUG
    printf("reduce with rule %d\n", n);
#endif
    if (yytflag && redcnt<YYREDMAX) redseq[redcnt++] = n;
    yyps -= yyr2[n];
    yypvt = yypv;
    yypv -= yyr2[n];
    yyval = yypv[1];
    m = n;
    /* find next state from goto table */
    n = yyr1[n];
    j = yypgo[n] + *yyps + 1;
    if (j>=YYLAST || yychk[ tmpstate = yyact[j] ] != -n) tmpstate = yyact[yypgo[n]];
    switch (m) { /* actions associated with grammar rules */
      
      case 1:
# line 205 "langparser.y"
      {
      		
      		yytrace ("module | statementlist eoltoken");
      		
      		if (pcyyerrct) {
      			
      			yyval = yypvt[-1];
      			
      			return (1);
      			}
      		
      		if (!pushbinaryoperation (moduleop, yypvt[-1], nil, &yyval))
      			goto cleanexit;
      		
      		return (0);
      	
       	cleanexit:
      	    while (--yypv - &yyv[0] > 0)
      			langdisposetree (*yypv);
      	
      		return (2);
      		} break;
      case 2:
# line 228 "langparser.y"
      {
      		
      		yytrace ("module | error");
      		
      		return (1);
      		} break;
      case 3:
# line 238 "langparser.y"
      {
      		
      		yytrace ("bracketedidentifier : identifiertoken");
      		
      		yyval = yypvt[-0];
      		} break;
      case 4:
# line 245 "langparser.y"
      {
      		
      		yytrace ("bracketedidentifier | '[' expr ']'");
      		
      		if (!pushunaryoperation (bracketop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 5:
# line 256 "langparser.y"
      {
      		
      		yytrace ("handlerheader | ontoken bracketedidentifier '(' namelist ')'");
      		
      		if (!pushbinaryoperation (procop, yypvt[-3], yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 6:
# line 264 "langparser.y"
      {
      		
      		yytrace ("handlerheader | ontoken bracketedidentifier '(' ')'");
      		
      		if (!pushbinaryoperation (procop, yypvt[-2], nil, &yyval))
      			goto cleanexit;
      		} break;
      case 7:
# line 282 "langparser.y"
      {
      		
      		yytrace ("optionalinit | empty");
      		
      		yyval = nil;
      		} break;
      case 8:
# line 289 "langparser.y"
      {
      		
      		yytrace ("optionalinit | assigntoken expr");
      		
      		yyval = yypvt[-0];
      		} break;
      case 9:
# line 296 "langparser.y"
      {
      		
      		yytrace ("optionalinit | error");
      		
      		yyval = nil;
      		} break;
      case 10:
# line 306 "langparser.y"
      {
      		
      		yytrace ("namelistid | optionalinit");
      		
      		if (yypvt[-0] == nil)
      			yyval = yypvt[-1]; /*just return the id*/
      			
      		else {
      			if (!pushbinaryoperation (assignlocalop, yypvt[-1], yypvt[-0], &yyval))
      				goto cleanexit;
      			}
      		} break;
      case 11:
# line 319 "langparser.y"
      {
      		
      		yytrace ("namelistid | error");
      		
      		yyval = nil;
      		} break;
      case 12:
# line 329 "langparser.y"
      {
      		
      		yytrace ("namelist | namelistid");
      		
      		yyval = yypvt[-0]; /*start the name list off with our address*/
      		} break;
      case 13:
# line 336 "langparser.y"
      {
      		
      		yytrace ("namelist | namelist ',' namelistid");
      		
      		if (!pushlastlink (yypvt[-0], yypvt[-2])) /*add new name to end of list*/
      			goto cleanexit;
      		} break;
      case 14:
# line 344 "langparser.y"
      {
      		
      		yytrace ("namelist | namelist ';' namelistid");
      		
      		if (!pushlastlink (yypvt[-0], yypvt[-2])) /*add new name to end of list*/
      			goto cleanexit;
      		} break;
      case 15:
# line 355 "langparser.y"
      {
      		
      		yytrace ("statementlist: statement");
      		
      		yyval = yypvt[-0]; /*start the statement list off with our address*/
      		} break;
      case 16:
# line 362 "langparser.y"
      {
      		
      		yytrace ("statementlist | statementlist ';' statement");
      		
      		if (!pushlastlink (yypvt[-0], yypvt[-2])) /*add new statement to end of list*/
      			goto cleanexit;
      		
      		yyval = yypvt[-2]; 
      		} break;
      case 17:
# line 375 "langparser.y"
      {
      		
      		yytrace ("bracketedstatementlist: '{' statementlist '}'");
      		
      		yyval = yypvt[-1];
      		} break;
      case 18:
# line 382 "langparser.y"
      {
      		
      		yytrace ("bracketedstatementlist | error");
      		
      		yyval = nil;
      		} break;
      case 19:
# line 392 "langparser.y"
      {
      		
      		yytrace ("derefid : term '^'");
      		
      		if (!pushunaryoperation (dereferenceop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 20:
# line 400 "langparser.y"
      {
      		
      		yytrace ("derefid | functionref '^'");
      		
      		if (!pushunaryoperation (dereferenceop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 21:
# line 408 "langparser.y"
      {
      		
      		yytrace ("derefid | '(' expr ')' '^'");
      		
      		if (!pushunaryoperation (dereferenceop, yypvt[-2], &yyval))
      			goto cleanexit;
      		} break;
      case 22:
# line 419 "langparser.y"
      {
      		
      		yytrace ("dottedid : term '.' bracketedidentifier");
      		
      		if (!pushbinaryoperation (dotop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 23:
# line 427 "langparser.y"
      {
      		
      		yytrace ("dottedid : term '.' error");
      		
      		yyval = yypvt[-2];
      		} break;
      case 24:
# line 437 "langparser.y"
      {
      		
      		yytrace ("rangeref: expr totoken expr");
      		
      		if (!pushbinaryoperation (rangeop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 25:
# line 448 "langparser.y"
      {
      		
      		yytrace ("arrayref: term '[' expr ']'");
      		
      		if (!pushbinaryoperation (arrayop, yypvt[-3], yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 26:
# line 456 "langparser.y"
      {
      		
      		yytrace ("arrayref | term '[' rangeref ']'");
      		
      		if (!pushbinaryoperation (arrayop, yypvt[-3], yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 27:
# line 464 "langparser.y"
      {
      		
      		yytrace ("arrayref | term '[' fieldspec ']'");
      		
      		if (!pushbinaryoperation (arrayop, yypvt[-3], yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 28:
# line 475 "langparser.y"
      {
      		
      		yytrace ("term: dottedid");
      		
      		yyval = yypvt[-0];
      		} break;
      case 29:
# line 482 "langparser.y"
      {
      		
      		yytrace ("term | arrayref");
      		
      		yyval = yypvt[-0];
      		} break;
      case 30:
# line 489 "langparser.y"
      {
      		
      		yytrace ("term | bracketedidentifier");
      		
      		yyval = yypvt[-0];
      		} break;
      case 31:
# line 496 "langparser.y"
      {
      		
      		yytrace ("term | derefid");
      		
      		yyval = yypvt[-0];
      		} break;
      case 32:
# line 506 "langparser.y"
      {
      		
      		yytrace ("statement: <empty statement>");
      		
      		if (!pushoperation (noop, &yyval)) /*a place for the debugger to stop*/
      			goto cleanexit;
      		} break;
      case 33:
# line 514 "langparser.y"
      {
      		
      		yytrace ("statement: expr");
      		
      		yyval = yypvt[-0];
      		} break;
      case 34:
# line 521 "langparser.y"
      {
      		
      		yytrace ("statement | term assigntoken expr");
      		
      		if (!pushbinaryoperation (assignop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 35:
# line 529 "langparser.y"
      {
      		
      		yytrace ("statement : handlerheader bracketedstatementlist");
      		
      		if (!pushbinaryoperation (moduleop, yypvt[-0], yypvt[-1], &yyval))
      			goto cleanexit;		
      		} break;
      case 36:
# line 537 "langparser.y"
      {
      		
      		yytrace ("statement : handlerheader '{' kernelcall '}'");
      		
      		if (!pushbinaryoperation (moduleop, yypvt[-1], yypvt[-3], &yyval))
      			goto cleanexit;		
      		} break;
      case 37:
# line 545 "langparser.y"
      {
      		
      		yytrace ("statement | localtoken '(' namelist ')'");
      		
      		if (!pushunaryoperation (localop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 38:
# line 553 "langparser.y"
      {
      		
      		yytrace ("statement | localtoken '{' namelist '}'");
      		
      		if (!pushunaryoperation (localop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 39:
# line 561 "langparser.y"
      {
      		
      		yytrace ("statement | globaltoken '(' namelist ')'");
      		
      		if (!pushunaryoperation (globalop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 40:
# line 569 "langparser.y"
      {
      		
      		yytrace ("statement | globaltoken '{' namelist '}'");
      		
      		if (!pushunaryoperation (globalop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 41:
# line 577 "langparser.y"
      {
      		
      		yytrace ("statement | fileloopheader bracketedstatementlist");
      		
      		if (!pushtripletstatementlists (nil, yypvt[-0], yypvt[-1]))
      			goto cleanexit;
      		
      		yyval = yypvt[-1];
      		} break;
      case 42:
# line 587 "langparser.y"
      {
      		
      		yytrace ("statement | loopheader bracketedstatementlist");
      		
      		if (!pushloopbody (yypvt[-0], yypvt[-1]))
      			goto cleanexit;
      		
      		yyval = yypvt[-1];
      		} break;
      case 43:
# line 597 "langparser.y"
      {
      		
      		yytrace ("statement | forloopheader bracketedstatementlist");
      		
      		if (!pushloopbody (yypvt[-0], yypvt[-1]))
      			goto cleanexit;
      		
      		yyval = yypvt[-1];
      		} break;
      case 44:
# line 607 "langparser.y"
      {
      		
      		yytrace ("statement | forinloopheader bracketedstatementlist");
      		
      		if (!pushloopbody (yypvt[-0], yypvt[-1]))
      			goto cleanexit;
      		
      		yyval = yypvt[-1];
      		} break;
      case 45:
# line 617 "langparser.y"
      {
      		
      		yytrace ("statement | ifheader bracketedstatementlist");
      		
      		if (!pushtripletstatementlists (yypvt[-0], nil, yypvt[-1]))
      			goto cleanexit;
      		
      		yyval = yypvt[-1];
      		} break;
      case 46:
# line 627 "langparser.y"
      {
      		
      		yytrace ("statement | ifheader bracketedstatementlist elsetoken bracketedstatementlist");
      		
      		if (!pushtripletstatementlists (yypvt[-2], yypvt[-0], yypvt[-3]))
      			goto cleanexit;
      		
      		yyval = yypvt[-3];
      		} break;
      case 47:
# line 637 "langparser.y"
      {
      		
      		yytrace ("statement | bundleheader bracketedstatementlist");
      		
      		if (!pushunarystatementlist (yypvt[-0], yypvt[-1]))
      			goto cleanexit;
      		
      		yyval = yypvt[-1];
      		} break;
      case 48:
# line 647 "langparser.y"
      {
      		
      		yytrace ("statement | breaktoken '(' ')'");
      		
      		if (!pushoperation (breakop, &yyval))
      			goto cleanexit;
      		} break;
      case 49:
# line 655 "langparser.y"
      {
      		
      		yytrace ("statement | breaktoken");
      		
      		if (!pushoperation (breakop, &yyval))
      			goto cleanexit;
      		} break;
      case 50:
# line 663 "langparser.y"
      {
      		
      		yytrace ("statement | continuetoken");
      		
      		if (!pushoperation (continueop, &yyval))
      			goto cleanexit;
      		} break;
      case 51:
# line 671 "langparser.y"
      {
      		
      		yytrace ("statement | returntoken");
      		
      		if (!pushunaryoperation (returnop, yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 52:
# line 679 "langparser.y"
      {
      		
      		yytrace ("statement | caseheader casebody");
      		
      		if (!pushtripletstatementlists (yypvt[-1], nil, yypvt[-3]))
      			goto cleanexit;
      		
      		yyval = yypvt[-3];
      		} break;
      case 53:
# line 689 "langparser.y"
      {
      		
      		yytrace ("statement | caseheader casebody elsetoken bracketedstatementlist");
      		
      		if (!pushtripletstatementlists (yypvt[-3], yypvt[-0], yypvt[-5]))
      			goto cleanexit;
      		
      		yyval = yypvt[-5];
      		} break;
      case 54:
# line 699 "langparser.y"
      {
      		
      		yytrace ("statement | withheader bracketedstatementlist");
      		
      		if (!pushtripletstatementlists (yypvt[-0], nil, yypvt[-1]))
      			goto cleanexit;
      		
      		yyval = yypvt[-1];
      		} break;
      case 55:
# line 709 "langparser.y"
      {
      		
      		yytrace ("statement | tryheader bracketedstatementlist");
      		
      		if (!pushtripletstatementlists (yypvt[-0], nil, yypvt[-1]))
      			goto cleanexit;
      		
      		yyval = yypvt[-1];
      		} break;
      case 56:
# line 719 "langparser.y"
      {
      		
      		yytrace ("statement | tryheader bracketedstatementlist elsetoken bracketedstatementlist");
      		
      		if (!pushtripletstatementlists (yypvt[-2], yypvt[-0], yypvt[-3]))
      			goto cleanexit;
      		
      		yyval = yypvt[-3];
      		} break;
      case 57:
# line 729 "langparser.y"
      {
      		
      		yytrace ("statement | expr error");
      		
      		yyval = yypvt[-1];
      		} break;
      case 58:
# line 747 "langparser.y"
      {
      		
      		yytrace ("kernelcall: kerneltoken '(' dottedid ')'");
      		
      		if (!pushkernelcall (yypvt[-1], &yyval))
      			return (1);
      		} break;
      case 59:
# line 778 "langparser.y"
      {
      		
      		yytrace ("fileloopheader: filelooptoken '(' bracketedidentifier intoken expr ')'");
      		
      		if (!pushquadruplet (fileloopop, yypvt[-3], yypvt[-1], nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 60:
# line 786 "langparser.y"
      {
      		
      		yytrace ("fileloopheader | filelooptoken '(' bracketedidentifier intoken expr ',' expr ')'");
      		
      		if (!pushquadruplet (fileloopop, yypvt[-5], yypvt[-3], nil, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 61:
# line 794 "langparser.y"
      {
      		
      		yytrace ("fileloopheader | filelooptoken '(' bracketedidentifier error");
      		
      		if (!pushquadruplet (fileloopop, yypvt[-1], nil, nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 62:
# line 805 "langparser.y"
      {
      		
      		yytrace ("loopheader: looptoken '(' statement ';' expr ';' statement ')'");
      		
      		if (!pushloop (yypvt[-5], yypvt[-3], yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 63:
# line 813 "langparser.y"
      {
      		
      		yytrace ("loopheader | looptoken");
      		
      		if (!pushloop (nil, nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 64:
# line 821 "langparser.y"
      {
      		
      		yytrace ("loopheader | looptoken '(' expr ')'");
      		
      		if (!pushloop (yypvt[-1], nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 65:
# line 829 "langparser.y"
      {
      		
      		yytrace ("loopheader | whiletoken expr");
      		
      		if (!pushloop (nil, yypvt[-0], nil, &yyval))
      			goto cleanexit;
      		} break;
      case 66:
# line 837 "langparser.y"
      {
      		
      		yytrace ("loopheader | looptoken '(' statement ';' expr ')'");
      		
      		if (!pushloop (yypvt[-3], yypvt[-1], nil, &yyval))
      			goto cleanexit;
      		} break;
      case 67:
# line 848 "langparser.y"
      {
      		
      		yytrace ("forloopheader: fortoken term assigntoken expr totoken expr");
      		
      		if (!pushquadruplet (forloopop, yypvt[-2], yypvt[-0], yypvt[-4], nil, &yyval))
      			goto cleanexit;
      		} break;
      case 68:
# line 856 "langparser.y"
      {
      		
      		yytrace ("forloopheader | fortoken '(' term assigntoken expr totoken expr ')' ");
      		
      		if (!pushquadruplet (forloopop, yypvt[-3], yypvt[-1], yypvt[-5], nil, &yyval))
      			goto cleanexit;
      		} break;
      case 69:
# line 864 "langparser.y"
      {
      		
      		yytrace ("forloopheader | fortoken term assigntoken expr downtotoken expr");
      		
      		if (!pushquadruplet (fordownloopop, yypvt[-2], yypvt[-0], yypvt[-4], nil, &yyval))
      			goto cleanexit;
      		} break;
      case 70:
# line 872 "langparser.y"
      {
      		
      		yytrace ("forloopheader | fortoken '(' term assigntoken expr downtotoken expr ')' ");
      		
      		if (!pushquadruplet (fordownloopop, yypvt[-3], yypvt[-1], yypvt[-5], nil, &yyval))
      			goto cleanexit;
      		} break;
      case 71:
# line 880 "langparser.y"
      {
      		
      		yytrace ("forloopheader: fortoken term assigntoken expr error");
      		
      		if (!pushquadruplet (noop, yypvt[-3], yypvt[-1], nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 72:
# line 888 "langparser.y"
      {
      		
      		yytrace ("forloopheader: fortoken term error");
      		
      		if (!pushquadruplet (noop, yypvt[-1], nil, nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 73:
# line 899 "langparser.y"
      {
      		
      		yytrace ("forinloopheader: fortoken term intoken expr");
      		
      		if (!pushquadruplet (forinloopop, yypvt[-0], yypvt[-2], nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 74:
# line 907 "langparser.y"
      {
      		
      		yytrace ("forinloopheader | fortoken '(' term intoken expr ')' ");
      		
      		if (!pushquadruplet (forinloopop, yypvt[-1], yypvt[-3], nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 75:
# line 918 "langparser.y"
      {
      		
      		yytrace ("ifheader: iftoken expr");
      		
      		if (!pushtriplet (ifop, yypvt[-0], nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 76:
# line 929 "langparser.y"
      {
      		
      		yytrace ("tryheader | trytoken");
      		
      		if (!pushtriplet (tryop, nil, nil, nil, &yyval)) /*it's really just a binary*/
      			goto cleanexit;
      		} break;
      case 77:
# line 940 "langparser.y"
      {
      		
      		yytrace ("bundleheader: bundletoken");
      		
      		if (!pushunaryoperation (bundleop, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 78:
# line 951 "langparser.y"
      {
      		
      		yytrace ("caseheader | casetoken expr");
      		
      		if (!pushtriplet (caseop, yypvt[-0], nil, nil, &yyval))
      			goto cleanexit;
      		} break;
      case 79:
# line 962 "langparser.y"
      {
      	
      		yytrace ("optionalstatementlist : (empty list)");
      		
      		yyval = nil;
      		} break;
      case 80:
# line 969 "langparser.y"
      {
      		
      		yytrace ("optionalstatementlist | bracketedstatementlist");
      		
      		yyval = yypvt[-0];
      		} break;
      case 81:
# line 979 "langparser.y"
      {
      		
      		yytrace ("casebody: expr optionalstatementlist");
      		
      		if (!pushbinaryoperation (casebodyop, yypvt[-1], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 82:
# line 987 "langparser.y"
      {
      		
      		yytrace ("casebody | casebody ';' expr optionalstatementlist");
      		
      		if (!pushbinaryoperation (casebodyop, yypvt[-1], yypvt[-0], &yyval))
      			goto cleanexit;
      		
      		if (!pushlastlink (yyval, yypvt[-3]))
      			goto cleanexit;
      		
      		yyval = yypvt[-3];
      		} break;
      case 83:
# line 1003 "langparser.y"
      {
      		
      		yytrace ("withheader: withtoken termlist");
      		
      		if (!pushbinaryoperation (withop, yypvt[-0], nil, &yyval))
      			goto cleanexit;
      		} break;
      case 84:
# line 1014 "langparser.y"
      {
      		
      		yytrace ("termlist: term");
      		
      		yyval = yypvt[-0];
      		} break;
      case 85:
# line 1021 "langparser.y"
      {
      		
      		yytrace ("termlist | termlist ',' term");
      		
      		if (!pushlastlink (yypvt[-0], yypvt[-2]))
      			goto cleanexit;
      			
      		yyval = yypvt[-2];
      		} break;
      case 86:
# line 1034 "langparser.y"
      {
      		
      		yytrace ("exprlist: expr");
      		
      		yyval = yypvt[-0];
      		} break;
      case 87:
# line 1041 "langparser.y"
      {
      		
      		yytrace ("exprlist | exprlist ',' expr");
      		
      		if (!pushlastlink (yypvt[-0], yypvt[-2]))
      			goto cleanexit;
      			
      		yyval = yypvt[-2];
      		} break;
      case 88:
# line 1055 "langparser.y"
      {
      	
      		yytrace ("optionalexprlist : (empty list)");
      		
      		yyval = nil;
      		} break;
      case 89:
# line 1062 "langparser.y"
      {
      		
      		yytrace ("optionalexprlist | exprlist");
      		
      		yyval = yypvt[-0];
      		} break;
      case 90:
# line 1094 "langparser.y"
      {
      		
      		yytrace ("optionalexpr : (empty expr)");
      		
      		yyval = nil;
      		} break;
      case 91:
# line 1101 "langparser.y"
      {
      		
      		yytrace ("optionalexpr | expr");
      		
      		yyval = yypvt[-0];
      		} break;
      case 92:
# line 1112 "langparser.y"
      {
      		
      		yytrace ("fieldspec: expr : expr ");
      		
      		if (!pushbinaryoperation (fieldop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 93:
# line 1123 "langparser.y"
      {
      		
      		yytrace ("fieldlist: fieldspec ");
      		
      		yyval = yypvt[-0];
      		} break;
      case 94:
# line 1130 "langparser.y"
      {
      		
      		yytrace ("fieldlist | fieldlist ',' fieldspec");
      		
      		if (!pushlastlink (yypvt[-0], yypvt[-2]))
      			goto cleanexit;
      		
      		yyval = yypvt[-2];
      		} break;
      case 95:
# line 1143 "langparser.y"
      {
      		
      		yytrace ("namedvalue: bracketedidentifier : expr ");
      		
      		if (!pushbinaryoperation (fieldop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 96:
# line 1154 "langparser.y"
      {
      		
      		yytrace ("namedvaluelist: namedvalue ");
      		
      		yyval = yypvt[-0];
      		} break;
      case 97:
# line 1161 "langparser.y"
      {
      		
      		yytrace ("namedvaluelist | namedvaluelist ',' namedvalue");
      		
      		if (!pushlastlink (yypvt[-0], yypvt[-2]))
      			goto cleanexit;
      		
      		yyval = yypvt[-2];
      		} break;
      case 98:
# line 1174 "langparser.y"
      {
      		
      		yytrace ("parameterlist : optionalexprlist");
      		
      		yyval = yypvt[-0];
      		} break;
      case 99:
# line 1181 "langparser.y"
      {
      		
      		yytrace ("parameterlist | namedvaluelist");
      		
      		yyval = yypvt[-0];
      		} break;
      case 100:
# line 1188 "langparser.y"
      {
      		
      		yytrace ("parameterlist | exprlist ',' namedvaluelist");
      		
      		if (!pushlastlink (yypvt[-0], yypvt[-2]))
      			goto cleanexit;
      		
      		yyval = yypvt[-2];
      		} break;
      case 101:
# line 1202 "langparser.y"
      {
      		
      		yytrace ("functionref: term '(' parameterlist ')'");
      		
      		if (!pushfunctioncall (yypvt[-3], yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 102:
# line 1212 "langparser.y"
      {
      		
      		yytrace ("expr | constanttoken");
      		
      		yyval = yypvt[-0];
      		} break;
      case 103:
# line 1219 "langparser.y"
      {
      		
      		yytrace ("expr | term");
      		
      		yyval = yypvt[-0];
      		} break;
      case 104:
# line 1226 "langparser.y"
      {
      		
      		yytrace ("expr | '@' term");
      		
      		if (!pushunaryoperation (addressofop, yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 105:
# line 1234 "langparser.y"
      {
      		
      		yytrace ("expr | functionref");
      		
      		yyval = yypvt[-0];
      		} break;
      case 106:
# line 1241 "langparser.y"
      {
      		
      		yytrace ("expr | plusplustoken term"); 
      		
      		if (!pushunaryoperation (incrpreop, yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 107:
# line 1249 "langparser.y"
      {
      		
      		yytrace ("expr | term plusplustoken");
      		
      		if (!pushunaryoperation (incrpostop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 108:
# line 1257 "langparser.y"
      {
      		
      		yytrace ("expr | minusminustoken term");
      		
      		if (!pushunaryoperation (decrpreop, yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 109:
# line 1265 "langparser.y"
      {
      		
      		yytrace ("expr | term minusminustoken");
      		
      		if (!pushunaryoperation (decrpostop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 110:
# line 1273 "langparser.y"
      {
      		
      		yytrace ("expr | '(' expr ')'");
      		
      		yyval = yypvt[-1];
      		} break;
      case 111:
# line 1280 "langparser.y"
      {
      		
      		yytrace ("expr | expr addtoken expr");
      		
      		if (!pushbinaryoperation (addop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 112:
# line 1288 "langparser.y"
      {
      		
      		yytrace ("expr | expr subtracttoken expr");
      		
      		if (!pushbinaryoperation (subtractop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 113:
# line 1296 "langparser.y"
      {
      		
      		yytrace ("expr | expr multiplytoken expr");
      		
      		if (!pushbinaryoperation (multiplyop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 114:
# line 1304 "langparser.y"
      {
      		
      		yytrace ("expr | expr dividetoken expr");
      		
      		if (!pushbinaryoperation (divideop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 115:
# line 1312 "langparser.y"
      {
      		
      		yytrace ("expr | expr modtoken expr");
      		
      		if (!pushbinaryoperation (modop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 116:
# line 1320 "langparser.y"
      {
      		
      		yytrace ("expr | expr EQtoken expr");
      		
      		if (!pushbinaryoperation (EQop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 117:
# line 1328 "langparser.y"
      {
      		
      		yytrace ("expr | expr NEtoken expr");
      		
      		if (!pushbinaryoperation (NEop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 118:
# line 1336 "langparser.y"
      {
      		
      		yytrace ("expr | expr LTtoken expr");
      		
      		if (!pushbinaryoperation (LTop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 119:
# line 1344 "langparser.y"
      {
      		
      		yytrace ("expr | expr LEtoken expr");
      		
      		if (!pushbinaryoperation (LEop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 120:
# line 1352 "langparser.y"
      {
      		
      		yytrace ("expr | expr GTtoken expr");
      		
      		if (!pushbinaryoperation (GTop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 121:
# line 1360 "langparser.y"
      {
      		
      		yytrace ("expr | expr GEtoken expr");
      		
      		if (!pushbinaryoperation (GEop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 122:
# line 1368 "langparser.y"
      {
      		
      		yytrace ("expr | expr beginswithtoken expr");
      		
      		if (!pushbinaryoperation (beginswithop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 123:
# line 1376 "langparser.y"
      {
      		
      		yytrace ("expr | expr endswithtoken expr");
      		
      		if (!pushbinaryoperation (endswithop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 124:
# line 1384 "langparser.y"
      {
      		
      		yytrace ("expr | expr containstoken expr");
      		
      		if (!pushbinaryoperation (containsop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 125:
# line 1392 "langparser.y"
      {
      		
      		yytrace ("expr | expr orortoken expr");
      		
      		if (!pushbinaryoperation (ororop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 126:
# line 1400 "langparser.y"
      {
      		
      		yytrace ("expr | expr andandtoken expr");
      		
      		if (!pushbinaryoperation (andandop, yypvt[-2], yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 127:
# line 1408 "langparser.y"
      {
      		
      		yytrace ("expr | subtracttoken expr %prec unaryminus");
      		
      		if (!pushunaryoperation (unaryop, yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 128:
# line 1416 "langparser.y"
      {
      		
      		yytrace ("expr | nottoken expr");
      		
      		if (!pushunaryoperation (notop, yypvt[-0], &yyval))
      			goto cleanexit;
      		} break;
      case 129:
# line 1424 "langparser.y"
      {
      		
      		yytrace ("expr | '{' exprlist '}'");
      		
      		if (!pushunaryoperation (listop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;
      case 130:
# line 1432 "langparser.y"
      {
      		
      		yytrace ("expr | '{' fieldlist '}'");
      		
      		if (!pushunaryoperation (recordop, yypvt[-1], &yyval))
      			goto cleanexit;
      		} break;    }
    goto enstack;
}
